/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.core.INbtSerializable;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class RegionAnchors
implements INbtSerializable<class_2487> {
    protected Map<String, TeleportAnchor> tpAnchors;

    public RegionAnchors() {
        this.tpAnchors = new HashMap<String, TeleportAnchor>();
    }

    public RegionAnchors(class_2487 tag) {
        this.deserializeNBT(tag);
    }

    public TeleportAnchor addTpAnchor(class_2338 pos) {
        String derivedName = ChatComponentBuilder.tinyBlockPos(pos);
        return this.addTpAnchor(pos, derivedName);
    }

    public boolean hasAnchor(String name) {
        return this.tpAnchors.containsKey(name);
    }

    public TeleportAnchor addTpAnchor(class_2338 pos, String name) {
        TeleportAnchor anchor = new TeleportAnchor(pos, name);
        this.tpAnchors.put(name, anchor);
        return anchor;
    }

    public void removeTpAnchor(String name) {
        this.tpAnchors.remove(name);
    }

    public void rename(String name, String newName) {
        TeleportAnchor teleportAnchor = this.tpAnchors.get(name);
        this.tpAnchors.remove(name);
        teleportAnchor.setName(newName);
        this.tpAnchors.put(newName, teleportAnchor);
    }

    public void addOrUpdate(String name, class_2338 pos) {
        if (this.tpAnchors.containsKey(name)) {
            TeleportAnchor teleportAnchor = this.tpAnchors.get(name);
            teleportAnchor.setPos(pos);
            return;
        }
        this.addTpAnchor(pos, name);
    }

    public void removeTpAnchor(class_2338 pos) {
        this.tpAnchors.remove(ChatComponentBuilder.tinyBlockPos(pos));
    }

    public TeleportAnchor getTpAnchor(String name) {
        return this.tpAnchors.get(name);
    }

    public List<TeleportAnchor> getAnchors() {
        return new ArrayList<TeleportAnchor>(this.tpAnchors.values());
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        this.tpAnchors.forEach((k, v) -> tag.method_10566(k, (class_2520)v.serializeNBT()));
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.tpAnchors = new HashMap<String, TeleportAnchor>();
        nbt.method_10541().forEach(k -> this.tpAnchors.put((String)k, new TeleportAnchor(nbt.method_10562(k))));
    }
}

